
// gwz2Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "gwz2.h"
#include "gwz2Dlg.h"
#include "Gra.h"
#include <omp.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// Cgwz2Dlg dialog




Cgwz2Dlg::Cgwz2Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(Cgwz2Dlg::IDD, pParent)
	, rozmiar(0)
	, biezaceKomorki(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void Cgwz2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PICTURECONTROL, pictureControl1);
	DDX_Control(pDX, IDC_TextCzas, tekstCzas1);
	DDX_Control(pDX, IDC_EDTLW, edtLW1);
}

BEGIN_MESSAGE_MAP(Cgwz2Dlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_NCCALCSIZE()
	ON_BN_CLICKED(IDC_BUTTON1, &Cgwz2Dlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &Cgwz2Dlg::OnBnClickedButton2)
//	ON_EN_CHANGE(IDC_EDTLW, &Cgwz2Dlg::OnEnChangeEdtlw)
ON_EN_UPDATE(IDC_EDTLW, &Cgwz2Dlg::OnEnUpdateEdtlw)
END_MESSAGE_MAP()


// Cgwz2Dlg message handlers

BOOL Cgwz2Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	rozmiar = 700;
	komorki1 = new char[rozmiar * rozmiar];
	komorki2 = new char[rozmiar * rozmiar];
	biezaceKomorki = komorki1;

	// OnBnClickedButton2();
	
	WartosciPoczatkowe(biezaceKomorki, rozmiar);

	int LiczbaWatkow=omp_get_num_procs();
	CString lwstr;
	lwstr.Format(_T("%d"), LiczbaWatkow);
	edtLW1.SetWindowTextA(lwstr);
	
	::SetWindowPos(m_hWnd , NULL, 0, 0, rozmiar+30, rozmiar+109, SWP_NOMOVE);
	::SetWindowPos(pictureControl1 , NULL, 0, 0, rozmiar, rozmiar, SWP_NOMOVE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void Cgwz2Dlg::OnPaint()
{
	rysujKomorki();
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR Cgwz2Dlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void Cgwz2Dlg::OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS* lpncsp)
{
	// TODO: Add your message handler code here and/or call default

	CRect rect;
	int dx, dy;

	if (lpncsp->rgrc[0].right == lpncsp->rgrc[1].right)
		dx = lpncsp->rgrc[1].left - lpncsp->rgrc[0].left;
	else
		dx = lpncsp->rgrc[0].right - lpncsp->rgrc[1].right;

	if (lpncsp->rgrc[0].bottom == lpncsp->rgrc[1].bottom)
		dy = lpncsp->rgrc[1].top - lpncsp->rgrc[0].top;
	else
		dy = lpncsp->rgrc[0].bottom - lpncsp->rgrc[1].bottom;

	::GetWindowRect(pictureControl1, &rect);
	::SetWindowPos(pictureControl1, NULL, 0, 0, rect.Width() + dx, rect.Height() + dy, SWP_NOMOVE);

	CDialog::OnNcCalcSize(bCalcValidRects, lpncsp);

}

void Cgwz2Dlg::rysujKomorki()
{
   pictureControl1.Invalidate();

   CPaintDC dc(&pictureControl1);
   CRect rect;
   int dx, dy;

   pictureControl1.GetWindowRect(&rect);
   dx = rect.Width() / rozmiar;
   dy = rect.Height() / rozmiar;

   dc.FillSolidRect(0, 0, rect.Width(), rect.Height(), 0xA0A0A0);
   for (int i = 0; i < rozmiar; ++i) {
      for (int j = 0; j < rozmiar; ++j) {
         if (biezaceKomorki[i * rozmiar + j] != 0)
            dc.FillSolidRect(i * dx, j * dy, dx, dy, 0x00AA00);
         else
            dc.FillSolidRect(i * dx, j * dy, dx, dy, 0xFFFFFF);
      }
   }
}

void Cgwz2Dlg::OnBnClickedButton1()
{
	double t0,t1;
	int LiczbaWatkow = 1;
	// TODO: Add your control notification handler code here

	char* poprzednieKomorki = (biezaceKomorki == komorki1) ? komorki2 : komorki1;
	
	CString lwstr;
	edtLW1.GetWindowTextA(lwstr);

	LiczbaWatkow=atoi(lwstr);
	t0=omp_get_wtime();
	kolejnePokolenie(biezaceKomorki, poprzednieKomorki, rozmiar, LiczbaWatkow);
	t1=omp_get_wtime();
	CString czasStr;
	czasStr.Format(_T(";  Czas: %1.3f"), t1-t0);
	
	lwstr.Format(_T("Liczba watkw: %d"),LiczbaWatkow);
	tekstCzas1.SetWindowTextA(lwstr + czasStr);
	biezaceKomorki = poprzednieKomorki;
	rysujKomorki();

}

void Cgwz2Dlg::OnBnClickedButton2()
{
	// TODO: Add your control notification handler code here
	srand(time(NULL));
	for (int i = 0; i < rozmiar * rozmiar; ++i)
		biezaceKomorki[i] = rand() % 2;
	rysujKomorki();

}


void Cgwz2Dlg::OnEnUpdateEdtlw()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_UPDATE flag ORed into the lParam mask.

	// TODO:  Add your control notification handler code here

}
